﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/lcs_PrivateDebugApi.h>
#include <nn/lcs/detail/Debug/lcs_Assert.h>

namespace nn { namespace lcs {

    Bit64 g_LocalCommunicationId = detail::DefaultLocalCommunicationId;
    InnerRole g_Role = InnerRole_Master;
    Bit16 g_SceneId = detail::DefaultSceneId;

    void SetLocalCommunicationId(Bit64 id) NN_NOEXCEPT
    {
        g_LocalCommunicationId = id;
    }

    Bit64 GetLocalCommunicationId() NN_NOEXCEPT
    {
        return g_LocalCommunicationId;
    }

    void SetInnerRole(InnerRole role) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(
            role == nn::lcs::InnerRole_None ||
            role == nn::lcs::InnerRole_Master ||
            role == nn::lcs::InnerRole_Slave);
        g_Role = role;
    }

    InnerRole GetInnerRole() NN_NOEXCEPT
    {
        return g_Role;
    }

    void SetSceneId(Bit16 id) NN_NOEXCEPT
    {
        g_SceneId = id;
    }

    Bit16 GetSceneId() NN_NOEXCEPT
    {
        return g_SceneId;
    }

}} // namespace nn::lcs
