﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <cstring>
#include <nn/nn_SdkAssert.h>
#include <nn/lcs/lcs_Config.h>

namespace nn { namespace lcs {

    Config::Config() NN_NOEXCEPT
    {
        ::std::memset(m_Name, '\0', UserNameBytesMax + 1);
    }

    void Config::SetName(const char* name) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(name);
        NN_SDK_REQUIRES_LESS_EQUAL(::std::strlen(name), UserNameBytesMax);
        if (name != nullptr)
        {
            ::std::strncpy(m_Name, name, UserNameBytesMax);
            m_Name[UserNameBytesMax] = 0;
        }
    }

    void Config::GetName(char* pOutName, size_t* pOutSize, size_t size) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pOutName);
        NN_SDK_REQUIRES_NOT_NULL(pOutSize);
        NN_SDK_REQUIRES_GREATER(size, 0U);
        if (pOutName != nullptr && 0U < size)
        {
            const size_t length = ::std::strlen(m_Name);
            const size_t copyLength = ::std::min(length, size - 1U);
            ::std::memcpy(pOutName, m_Name, copyLength);
            pOutName[copyLength] = 0;
            if (pOutSize != nullptr)
            {
                *pOutSize = copyLength + 1U;
            }
        }
    }


}} // namespace nn::lcs
