﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/lcs_Result.h>
#include <nn/lcs/detail/lcs_Definition.h>
#include <nn/lcs/detail/lcs_Socket.h>
#include <nn/lcs/detail/Debug/lcs_Log.h>
#include <nn/socket.h>

namespace nn { namespace lcs { namespace detail
{
    int SocketOpen(int* socket) NN_NOEXCEPT
    {
        *socket = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp);
        if (*socket < 0)
        {
            NN_LCS_LOG_DEBUG("socket opend failed: %d\n", nn::socket::GetLastError());
            return -1;
        }

        if (SetSockLinger(socket) < 0)
        {
            NN_LCS_LOG_DEBUG("set sock opt failed(SO_NN_LINGER): %d\n", nn::socket::GetLastError());
            return -1;
        }

        if (SetSockReuseAddr(socket) < 0)
        {
            NN_LCS_LOG_DEBUG("set sock opt failed(SO_REUSEADDR): %d\n", nn::socket::GetLastError());
            return -1;
        }

        nn::socket::SockAddrIn sockAddr = {};
        sockAddr.sin_addr.S_addr = nn::socket::InetHtonl(nn::socket::InAddr_Any);
        sockAddr.sin_port = nn::socket::InetHtons(static_cast<uint16_t>(TcpPort));
        sockAddr.sin_family = nn::socket::Family::Af_Inet;
        if (nn::socket::Bind(*socket, reinterpret_cast<nn::socket::SockAddr*>(&sockAddr), sizeof(sockAddr)) < 0)
        {
            NN_LCS_LOG_DEBUG("socket bind failed: %d\n", nn::socket::GetLastError());
            return -1;
        }
        return 0;
    }

    int SetSockLinger(int* socket) NN_NOEXCEPT
    {
        nn::socket::Linger linger;
        linger.l_onoff = 1;
        linger.l_linger = 1;

        return nn::socket::SetSockOpt(*socket, nn::socket::Level::Sol_Socket, nn::socket::Option::So_Nn_Linger, &linger, sizeof(linger));
    }

    int SetSockReuseAddr(int* socket) NN_NOEXCEPT
    {
        int yes = 1;
        return nn::socket::SetSockOpt(*socket, nn::socket::Level::Sol_Socket, nn::socket::Option::So_ReuseAddr, &yes, sizeof(yes));
    }

    int SocketClose(int* socket) NN_NOEXCEPT
    {
        nn::socket::Shutdown(*socket, nn::socket::ShutdownMethod::Shut_RdWr);
        return nn::socket::Close(*socket);
    }

    int SocketConnect(int* socket, Ipv4Address address) NN_NOEXCEPT
    {
        nn::socket::SockAddrIn sockAddr = {};

        sockAddr.sin_addr.S_addr = nn::socket::InetHtonl(address);
        sockAddr.sin_port = nn::socket::InetHtons(static_cast<uint16_t>(TcpPort));
        sockAddr.sin_family = nn::socket::Family::Af_Inet;

        return nn::socket::Connect(*socket, reinterpret_cast<nn::socket::SockAddr*>(&sockAddr), sizeof(sockAddr));
    }

}}} // end of namespace nn::lcs
