﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/detail/lcs_Event.h>

namespace nn { namespace lcs { namespace detail
{
    EventManager::EventManager() NN_NOEXCEPT
        : m_IsAttachEvent(false)
    {
    }

    void EventManager::Initialize(nn::os::SystemEventType* pEvent) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pEvent);
        NN_SDK_REQUIRES(!m_IsAttachEvent);

        if (!m_IsAttachEvent)
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(
                nn::os::CreateSystemEvent(pEvent,
                    nn::os::EventClearMode_ManualClear, false));

            m_StateChangeEvent = pEvent;
            m_IsAttachEvent = true;
        }
    }

    void EventManager::Finalize() NN_NOEXCEPT
    {
        if (m_IsAttachEvent)
        {
            nn::os::DestroySystemEvent(m_StateChangeEvent);
            m_IsAttachEvent = false;
        }
    }

    void EventManager::SignalEvent() NN_NOEXCEPT
    {
        if (m_IsAttachEvent)
        {
            nn::os::SignalSystemEvent(m_StateChangeEvent);
        }
    }

}}} // end of namespace nn::lcs
