﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lcs/detail/Debug/lcs_Log.h>
#include <nn/lcs/detail/Packet/lcs_Packet.h>
#include <nn/lcs/detail/Packet/lcs_PacketReceiver.h>

namespace nn { namespace lcs { namespace detail
{

    ssize_t RecvCommonHeaderWithPeek(int socket, CommonHeader* pOutHeader) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pOutHeader);

        ssize_t recvSize = 0;
        ssize_t readSize = static_cast<ssize_t>(sizeof(CommonHeader));

        // 届いている TCP データの確認
        recvSize = nn::socket::Recv(socket, pOutHeader, sizeof(CommonHeader), nn::socket::MsgFlag::Msg_Peek);
        //NN_LCS_LOG_DEBUG("recvSize : %d\n", recvSize);
        if (recvSize >= readSize)
        {
            return recvSize;
        }
        else if (recvSize == 0)
        {
            return 0;
        }
        return -1;
    }

    ssize_t RecvData(int socket, void* buffer, size_t bufferSize, size_t readSize) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(buffer);
        NN_SDK_ASSERT_GREATER_EQUAL(bufferSize, readSize);

        ssize_t recvSize = 0;

        // 届いている TCP データの確認
        recvSize = nn::socket::Recv(socket, buffer, bufferSize, nn::socket::MsgFlag::Msg_Peek);
        //NN_LCS_LOG_DEBUG("recvSize : %d / readSize : %d\n", recvSize, readSize);
        if (recvSize >= static_cast<ssize_t>(readSize))
        {
            recvSize = nn::socket::Recv(socket, buffer, readSize, nn::socket::MsgFlag::Msg_None);
            //NN_LCS_LOG_DEBUG("recvSize : %d\n", recvSize);
            if (recvSize == static_cast<ssize_t>(readSize))
            {
                return recvSize;
            }
        }
        else if (recvSize == 0)
        {
            return 0;
        }
        return -1;
    }

}}} // end of namespace nn::lcs
