﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }
}

namespace nn.irsensor
{
    [CppRefPath(@"<nn/irsensor/irsensor_IIrSensorSystemServer.sfdl.h>")]
    public interface IIrSensorSystemServer : IServiceObject
    {
        [MethodId(500)]
        Result SetAppletResourceUserId(nn.applet.AppletResourceUserId value);

        [MethodId(501)]
        Result RegisterAppletResourceUserId(
            nn.applet.AppletResourceUserId aruid, bool enablesInput);

        [MethodId(502)]
        Result UnregisterAppletResourceUserId(
            nn.applet.AppletResourceUserId aruid);

        [MethodId(503)]
        Result EnableAppletToGetInput(
            nn.applet.AppletResourceUserId aruid, bool enablesInput);
    }
}
