﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/irsensor/system/irsensor_Applet.h>

#include "detail/irsensor_AppletImpl.h"

namespace nn { namespace irsensor { namespace system {

void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& value
                         ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::irsensor::detail::SetAppletResourceUserId(value));
}

void RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::irsensor::detail::RegisterAppletResourceUserId(aruid, enablesInput));
}

void UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::irsensor::detail::UnregisterAppletResourceUserId(aruid));
}

void EnableAppletToGetInput(const ::nn::applet::AppletResourceUserId& aruid,
                            bool enablesInput) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::irsensor::detail::EnableAppletToGetInput(aruid, enablesInput));
}

}}} // namespace nn::irsensor::system
