﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/os/os_SharedMemory.h>

#include "irsensor_StatusManager.h"

namespace nn { namespace irsensor { namespace detail {

class StatusManagerHolder final
{
    NN_DISALLOW_COPY(StatusManagerHolder);
    NN_DISALLOW_MOVE(StatusManagerHolder);

private:
    //!< 新規に構築されたか否か
    bool m_IsCreated;

    //!< 共有メモリオブジェクト
    ::nn::os::SharedMemoryType m_SharedMemory;

public:
    StatusManagerHolder() NN_NOEXCEPT;

    ~StatusManagerHolder() NN_NOEXCEPT;

    ::nn::Result Initialize() NN_NOEXCEPT;

    void Finalize() NN_NOEXCEPT;

    ::nn::Result Clear() NN_NOEXCEPT;

    void Attach(::nn::os::NativeHandle handle, bool managed) NN_NOEXCEPT;

    StatusManager* GetStatusManager() const NN_NOEXCEPT;

    size_t GetSharedMemorySize() const NN_NOEXCEPT;

    ::nn::os::NativeHandle GetSharedMemoryHandle() const NN_NOEXCEPT;

    bool IsSharedMemoryMapped() const NN_NOEXCEPT;
};

}}} // namespace nn::irsensor::detail
