﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/applet/applet_Types.h>

#include "irsensor_ActivationCount.h"
#include "irsensor_IrSensorSession.h"
#include "irsensor_StatusManagerHolder.h"

namespace nn { namespace irsensor { namespace detail {

//!< IrSensor のセッションを管理するためのクラスです。
class SessionManager final
{
    NN_DISALLOW_COPY(SessionManager);
    NN_DISALLOW_MOVE(SessionManager);

private:
    //!< IrSensor のセッションのエントリを表す構造体です。
    struct Entry final
    {
        // セッションが初期化済みか否かを表す値
        ::std::atomic_bool isInitialized;

        // セッションの初期化排他用ミューテックス
        LockableMutexType mutex;

        // セッションの格納先となるメモリ領域
        ::nn::util::TypedStorage<IrSensorSession,
            sizeof(IrSensorSession), NN_ALIGNOF(IrSensorSession)> storage;
    };

    //!< IrSensor のセッションのエントリ
    Entry m_Entry;

public:
    SessionManager() NN_NOEXCEPT;

    ~SessionManager() NN_NOEXCEPT;

    //!< IrSensor のセッションを返します。
    IrSensorSession* GetSession(const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    //!< IrSensor のセッションを終了します。
    void FinalizeSession(const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;
};

SessionManager& GetSessionManager() NN_NOEXCEPT;

}}} // namespace nn::irsensor::detail
