﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/irsensor/irsensor_ResultPrivate.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_NativeHandle.h>

#include "irsensor_IrSensorServer.h"
#include "irsensor_IrCameraHandle.h"
#include "irsensor_StatusManagerHolder.h"
#include "irsensor_LockableMutexType.h"
#include "irsensor_IrSensorSession.h"
#include "irsensor_SessionManager.h"

namespace nn { namespace irsensor { namespace detail {

SessionManager::SessionManager() NN_NOEXCEPT
{
    m_Entry.isInitialized = false;
    ::nn::os::InitializeMutex(&m_Entry.mutex._mutex, false, 0);
}

SessionManager::~SessionManager() NN_NOEXCEPT
{
    // 何もしない
}

//!< IrSensor のセッションを返します。
IrSensorSession* SessionManager::GetSession(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    IrSensorSession* pSession = &::nn::util::Get(m_Entry.storage);

    if (!m_Entry.isInitialized)
    {
        ::std::lock_guard<decltype(m_Entry.mutex)> locker(m_Entry.mutex);

        if (!m_Entry.isInitialized)
        {
            new(pSession) IrSensorSession(aruid);

            m_Entry.isInitialized = true;
        }
    }

    return pSession;
}

//!< IrSensor のセッションを終了します。
void SessionManager::FinalizeSession(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    NN_UNUSED(aruid);

    ::std::lock_guard<decltype(m_Entry.mutex)> locker(m_Entry.mutex);
    if (m_Entry.isInitialized)
    {
        IrSensorSession* pSession = &::nn::util::Get(m_Entry.storage);
        pSession->~IrSensorSession();
        m_Entry.isInitialized = false;
    }
}

SessionManager& GetSessionManager() NN_NOEXCEPT
{
    static SessionManager s_SessionManager;
    return s_SessionManager;
}

}}} // namespace nn::irsensor::detail
