﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/irsensor/irsensor_IIrSensorSystemServer.h>
#include <nn/irsensor/irsensor_ServiceName.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ISharedObject.h>

#include "irsensor_IrSensorSystemServer.h"
#include "irsensor_LockableMutexType.h"

namespace nn { namespace irsensor { namespace detail {

namespace {

//!< IPC 用ヒープメモリを扱うクラスです。
typedef ::nn::sf::ExpHeapStaticAllocator<16 * 1024, IrSensorSystemServer> Allocator;

}

::nn::Result CreateIrSensorSystemServerProxy(
    ::nn::sf::SharedPointer<IIrSensorSystemServer>* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    NN_FUNCTION_LOCAL_STATIC(
        ::nn::sf::SharedPointer<IIrSensorSystemServer>, s_SharedPointer);

    static LockableMutexType s_Mutex = { NN_OS_MUTEX_INITIALIZER(false) };

    NN_FUNCTION_LOCAL_STATIC(
        ::std::atomic<bool>, s_IsAllocatorInitialized, (false));

    if (!s_IsAllocatorInitialized)
    {
        ::std::lock_guard<decltype(s_Mutex)> locker(s_Mutex);

        if (!s_IsAllocatorInitialized)
        {
            Allocator::Initialize(::nn::lmem::CreationOption_NoOption);

            s_IsAllocatorInitialized = true;
        }
    }

    NN_FUNCTION_LOCAL_STATIC(
        ::std::atomic<bool>, s_IsSharedPointerInitialized, (false));

    if (!s_IsSharedPointerInitialized)
    {
        ::std::lock_guard<decltype(s_Mutex)> locker(s_Mutex);

        if (!s_IsSharedPointerInitialized)
        {
            NN_RESULT_DO((::nn::sf::CreateHipcProxyByName<
                IIrSensorSystemServer, Allocator::Policy>)(&s_SharedPointer,
                                                      IrSensorSystemServiceName));

            s_IsSharedPointerInitialized = true;
        }
    }

    *pOutValue = s_SharedPointer;

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::irsensor::detail
