﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/irsensor/irsensor_IIrSensorSystemServer.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "irsensor_IrSensorSystemServer.h"
#include "irsensor_StaticObject.h"
#include "irsensor_ResourceManager.h"

namespace nn { namespace irsensor { namespace detail {

IrSensorSystemServer::IrSensorSystemServer() NN_NOEXCEPT
{
    // 何もしない
}

::nn::Result IrSensorSystemServer::SetAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT
{
    GetResourceManager().SetAppletResourceUserId(value);
    NN_RESULT_SUCCESS;
}

::nn::Result IrSensorSystemServer::RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    NN_RESULT_DO(
        GetResourceManager().RegisterAppletResourceUserId(aruid, enablesInput));
    NN_RESULT_SUCCESS;
}

::nn::Result IrSensorSystemServer::UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    GetResourceManager().UnregisterAppletResourceUserId(aruid);
    NN_RESULT_SUCCESS;
}

::nn::Result IrSensorSystemServer::EnableAppletToGetInput(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    GetResourceManager().EnableAppletToGetInput(aruid, enablesInput);
    NN_RESULT_SUCCESS;
}

::nn::Result CreateIrSensorSystemServerProxy(
    ::nn::sf::SharedPointer<IIrSensorSystemServer>* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    *pOutValue = StaticObject<
        ::nn::sf::UnmanagedServiceObject<IIrSensorSystemServer, IrSensorSystemServer>
        >::Get().GetShared();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::irsensor::detail
