﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/irsensor/irsensor_IIrSensorSystemServer.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

#include "irsensor_AppletImpl.h"
#include "irsensor_IrSensorSystemServer.h"

namespace nn { namespace irsensor { namespace detail {

::nn::Result SetAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IIrSensorSystemServer> pProxy;
    NN_RESULT_DO(CreateIrSensorSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetAppletResourceUserId(value));
    NN_RESULT_SUCCESS;
}

::nn::Result RegisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IIrSensorSystemServer> pProxy;
    NN_RESULT_DO(CreateIrSensorSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->RegisterAppletResourceUserId(aruid, enablesInput));
    NN_RESULT_SUCCESS;
}

::nn::Result UnregisterAppletResourceUserId(
    const ::nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IIrSensorSystemServer> pProxy;
    NN_RESULT_DO(CreateIrSensorSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->UnregisterAppletResourceUserId(aruid));
    NN_RESULT_SUCCESS;
}

::nn::Result EnableAppletToGetInput(
    const ::nn::applet::AppletResourceUserId& aruid,
    bool enablesInput) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IIrSensorSystemServer> pProxy;
    NN_RESULT_DO(CreateIrSensorSystemServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->EnableAppletToGetInput(aruid, enablesInput));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::irsensor::detail
