﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }
}

namespace nn.hid
{
    [CppRefPath(@"<nn/hid/hid_NpadCommonTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct NpadStyleSet
    {
    }
}

namespace nn.hidbus
{
    [CppRefPath(@"<nn/hidbus/hidbus_Api.h>")]
    [ExternalStruct(8, 8)]
    public struct BusHandle
    {
    }

    [CppRefPath(@"<nn/hidbus/hidbus_Api.h>")]
    [ExternalStruct(4, 4)]
    public struct ExternalDeviceInfo
    {
    }

    [CppRefPath(@"<nn/hidbus/hidbus_Api.h>")]
    [ExternalStruct(8, 4)]
    public struct BusInfo
    {
    }

    [CppRefPath(@"<nn/hidbus/hidbus_Api.h>")]
    [ExternalStruct(56, 8)]
    public struct JoyPollingReceivedData
    {
    }

    [CppRefPath(@"<nn/hidbus/hidbus_Api.h>")]
    public interface IHidbusServer : IServiceObject
    {
        [MethodId(1)]
        Result GetBusHandle(Out<nn.hidbus.BusHandle> outHandle,
                            Out<bool> hasHandle,
                            uint32_t npadId,
                            uint64_t busTypeId,
                            nn.applet.AppletResourceUserId aruid);

        [MethodId(2)]
        Result IsExternalDeviceConnected(Out<bool> isAttached, nn.hidbus.BusHandle handle);

        [MethodId(3)]
        Result Initialize(nn.hidbus.BusHandle handle, nn.applet.AppletResourceUserId aruid);

        [MethodId(4)]
        Result Finalize(nn.hidbus.BusHandle handle, nn.applet.AppletResourceUserId aruid);

        [MethodId(5)]
        Result EnableExternalDevice(nn.hidbus.BusHandle handle, bool isEnabled, uint64_t version, nn.applet.AppletResourceUserId aruid);

        [MethodId(6)]
        Result GetExternalDeviceId(Out<uint32_t> deviceId, nn.hidbus.BusHandle handle);

        [MethodId(7)]
        Result SendCommandAsync(
            [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer inData,
            nn.hidbus.BusHandle handle);

        [MethodId(8)]
        Result GetSendCommandAsynceResult(
            Out<uint32_t> outSize,
            [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer outData,
            nn.hidbus.BusHandle handle);

        [MethodId(9)]
        Result SetEventForSendCommandAsycResult(
            Out<NativeHandle> attachmentDataReceiveEventHandle,
            nn.hidbus.BusHandle handle);

        [MethodId(10)]
        Result GetSharedMemoryHandle(
            Out<NativeHandle> outValue);

        [MethodId(11)]
        Result EnableJoyPollingReceiveMode(
            [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer inData,
            NativeHandle transferMemoryHandle,
            uint32_t transferMemorySize,
            uint32_t mode,
            nn.hidbus.BusHandle handle);

        [MethodId(12)]
        Result DisableJoyPollingReceiveMode(
            nn.hidbus.BusHandle handle);

        [MethodId(13)]
        Result GetPollingData(OutArray<JoyPollingReceivedData> pOutArray, nn.hidbus.BusHandle handle);
    }
}
