﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <atomic>
#include <mutex>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hidbus/hidbus_IHidbusSystemServer.sfdl.h>
#include <nn/hidbus/hidbus_ServiceName.h>
#include <nn/lmem/lmem_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ISharedObject.h>

#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/hid/hid_ServiceName.h>

namespace nn { namespace hidbus { namespace detail {

namespace {

nn::os::SdkMutexType  g_Mutex     = NN_OS_SDK_MUTEX_INITIALIZER();
bool                  g_IsCreated = false;

nn::sf::ProxyObjectAllocator<16> g_ServiceObjectAllocator = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER;

}

::nn::Result CreateHidbusSystemServerProxy(
    ::nn::sf::SharedPointer<IHidbusSystemServer>* pOutValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    ::std::lock_guard<decltype(g_Mutex)> locker(g_Mutex);

    NN_FUNCTION_LOCAL_STATIC(
        ::nn::sf::SharedPointer<IHidbusSystemServer>, s_SharedPointer);

    if (!g_IsCreated)
    {
        g_ServiceObjectAllocator.Initialize();
        // hid:sys サービスを使用して HidbusSystemServer を取得する
        ::nn::sf::SharedPointer<nn::hid::IHidSystemServer> hidSystemSharedPointer;

        NN_RESULT_DO(nn::sf::CreateHipcProxyByName<nn::hid::IHidSystemServer>(&hidSystemSharedPointer,
                                                                              g_ServiceObjectAllocator.GetMemoryResource(),
                                                                              nn::hid::HidSystemServiceName));

        NN_RESULT_DO(hidSystemSharedPointer->GetHidbusSystemServiceObject(&s_SharedPointer));

        g_IsCreated = true;
    }

    *pOutValue = s_SharedPointer;

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hidbus::detail
