﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hidbus/hidbus_IHidbusServer.sfdl.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace hidbus { namespace detail {

//!< hidbus サービスのプロクシを作成します。
::nn::Result CreateHidbusServerProxy(
    ::nn::sf::SharedPointer<IHidbusServer>* outValue) NN_NOEXCEPT;

}}} // namespace nn::hidbus::detail
