﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/debug/hid_TouchScreen.h>

#include "detail/hid_TouchScreenImpl.h"

namespace nn { namespace hid {

void InitializeTouchScreen() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeTouchScreen());
}

#define NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(n)\
template<>\
void GetTouchScreenState(TouchScreenState<n>* outValue) NN_NOEXCEPT\
{\
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetTouchScreenState(outValue));\
}

#define NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(n)\
template<>\
int GetTouchScreenStates(TouchScreenState<n>* outStates,\
                          int count) NN_NOEXCEPT\
{\
    int gotCount = 0;\
    NN_ABORT_UNLESS_RESULT_SUCCESS(\
        detail::GetTouchScreenStates(&gotCount, outStates, count));\
    return gotCount;\
}

NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(1)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(2)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(3)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(4)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(5)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(6)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(7)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(8)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(9)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(10)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(11)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(12)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(13)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(14)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(15)
NN_HID_DEFINE_GET_TOUCH_SCREEN_STATE(16)

NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(1)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(2)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(3)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(4)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(5)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(6)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(7)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(8)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(9)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(10)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(11)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(12)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(13)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(14)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(15)
NN_HID_DEFINE_READ_TOUCH_SCREEN_STATES(16)

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeTouchScreen() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::hid::detail::FinalizeTouchScreen());
}

#define NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(n)\
template<>\
void SetTouchScreenAutoPilotState(const TouchScreenAutoPilotState<n>& value\
    ) NN_NOEXCEPT\
{\
    NN_ABORT_UNLESS_RESULT_SUCCESS(\
        ::nn::hid::detail::SetTouchScreenAutoPilotState(value));\
}

void UnsetTouchScreenAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetTouchScreenAutoPilotState());
}

NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(1)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(2)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(3)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(4)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(5)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(6)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(7)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(8)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(9)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(10)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(11)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(12)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(13)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(14)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(15)
NN_HID_DEBUG_DEFINE_SET_TOUCH_SCREEN_AUTO_PILOT_STATE(16)

}}} // namespace nn::hid::debug
