﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_PlayReport.h>

#include "detail/hid_PlayReportImpl.h"

namespace nn { namespace hid { namespace system {

void BindPlayReportControllerUsageUpdateEvent(::nn::os::SystemEventType* pEvent,
                                              ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::BindPlayReportControllerUsageUpdateEvent(pEvent, clearMode));
}

int GetPlayReportControllerUsages(PlayReportControllerUsage* pOutValues, int count) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValues);
    NN_SDK_REQUIRES_GREATER(count, 0);

    int returnCount = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::GetPlayReportControllerUsages(&returnCount, pOutValues, count));

    return returnCount;
}

void BindPlayReportRegisteredDeviceUpdateEvent(::nn::os::SystemEventType* pEvent,
                                               ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::BindPlayReportRegisteredDeviceUpdateEvent(pEvent, clearMode));
}

PlayReportDeviceType GetPlayReportDeviceType(DeviceTypeSet& deviceType) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_LESS_EQUAL(deviceType.CountPopulation(), 1);

    for (int deviceTypeIndex = 0; deviceTypeIndex < system::DeviceTypeSet::StorageBitCount; deviceTypeIndex++)
    {
        if (deviceType[deviceTypeIndex] == 1)
        {
            // デバイスタイプの変換
            switch (deviceTypeIndex)
            {
            case system::DeviceType::JoyConLeft::Index:
                return system::PlayReportDeviceType_JoyConLeft;
            case system::DeviceType::JoyConRight::Index:
                return system::PlayReportDeviceType_JoyConRight;
            case system::DeviceType::HandheldJoyLeft::Index:
                return system::PlayReportDeviceType_JoyConLeft;
            case system::DeviceType::HandheldJoyRight::Index:
                return system::PlayReportDeviceType_JoyConRight;
            case system::DeviceType::FullKeyController::Index:
                return system::PlayReportDeviceType_SwitchProController;
            default:
                return system::PlayReportDeviceType_Unknown;
            }
        }
    }

    return system::PlayReportDeviceType_Unknown;
}

}}} // namespace nn::hid::system
