﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_NpadColor.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/hid_ResultController.h>
#include <nn/result/result_HandlingUtility.h>

#include "detail/hid_NpadImpl.h"

namespace nn { namespace hid {

::nn::Result GetNpadControllerColor(NpadControllerColor* pOutValue, const NpadIdType& id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    auto result = detail::GetNpadControllerColor(pOutValue, id);

    if (ResultNpadColorNotAvailable().Includes(result) ||
        ResultNpadControllerNotConnected().Includes(result))
    {
        NN_RESULT_THROW(result);
    }

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    NN_RESULT_SUCCESS;
}

::nn::Result GetNpadControllerColor(NpadControllerColor* pOutLeftColor, NpadControllerColor* pOutRightColor, const NpadIdType& id) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutLeftColor);
    NN_SDK_REQUIRES_NOT_NULL(pOutRightColor);

    auto result = detail::GetNpadControllerColor(pOutLeftColor, pOutRightColor, id);

    if (ResultNpadColorNotAvailable().Includes(result) ||
        ResultNpadControllerNotConnected().Includes(result))
    {
        NN_RESULT_THROW(result);
    }

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    NN_RESULT_SUCCESS;
}

}} // namespace nn::hid
