﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_NpadCommonImpl.h"
#include "detail/hid_NpadId.h"
#include "detail/hid_NpadImpl.h"

namespace nn { namespace hid {

void InitializeNpad() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeNpad());
}

void SetSupportedNpadStyleSet(NpadStyleSet style) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(style.IsAllOn() == false);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetSupportedNpadStyleSet(style));
}

NpadStyleSet GetSupportedNpadStyleSet() NN_NOEXCEPT
{
    NpadStyleSet style;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetSupportedNpadStyleSet(&style));

    return style;
}

void SetSupportedNpadIdType(const NpadIdType* pIds, size_t count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetSupportedNpadIdType(pIds, static_cast<int>(count)));
}

void BindNpadStyleSetUpdateEvent(const NpadIdType& id,
                     ::nn::os::SystemEventType* pEvent,
                     ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::BindNpadStyleSetUpdateEvent(id, pEvent, clearMode));
}

NpadStyleSet GetNpadStyleSet(const NpadIdType& id) NN_NOEXCEPT
{
    NpadStyleSet style;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetNpadStyleSet(&style, id));

    return style;
}

void DisconnectNpad(const NpadIdType& id) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::DisconnectNpad(id));
}

Bit8 GetPlayerLedPattern(const NpadIdType& id) NN_NOEXCEPT
{
    Bit8 pattern;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetPlayerLedPattern(&pattern, id));

    return pattern;
}

bool IsUnintendedHomeButtonInputProtectionEnabled(const NpadIdType& id) NN_NOEXCEPT
{
    bool isEnabled;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::IsUnintendedHomeButtonInputProtectionEnabled(&isEnabled, id));

    return isEnabled;
}

void EnableUnintendedHomeButtonInputProtection(const NpadIdType& id, bool enabled) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::EnableUnintendedHomeButtonInputProtection(id, enabled));
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeNpad() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeNpad());
}

}}} // namespace nn::hid::debug
