﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/debug/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>
#include <nn/TargetConfigs/build_Base.h>

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_CLANG) || \
    defined(NN_BUILD_CONFIG_TOOLCHAIN_GCC)
#include <nn/hid/detail/hid_KeyboardKeyDefinition.h>
#endif

#include "detail/hid_KeyboardImpl.h"

namespace nn { namespace hid {

void InitializeKeyboard() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeKeyboard());
}

void GetKeyboardState(KeyboardState* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetKeyboardState(pOutValue));
}

int GetKeyboardStates(KeyboardState outValues[], int count) NN_NOEXCEPT
{
    int gotCount = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetKeyboardStates(&gotCount, outValues, count));
    return gotCount;
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeKeyboard() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(::nn::hid::detail::FinalizeKeyboard());
}

void SetKeyboardAutoPilotState(const KeyboardAutoPilotState& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetKeyboardAutoPilotState(value));
}

void UnsetKeyboardAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetKeyboardAutoPilotState());
}

}}} // namespace nn::hid::debug

namespace nn { namespace hid { namespace system {

void SendKeyboardLockKeyEvent(KeyboardLockKeyEventSet value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SendKeyboardLockKeyEvent(value));
}

}}} // namespace nn::hid::system
