﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_JoyXpad.h>
#include <nn/os/os_SystemEvent.h>

#include "detail/hid_JoyXpadImpl.h"

namespace nn { namespace hid {

int GetXpadIds(JoyXpadId* outXpadIds, int count) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetXpadIds(&gotCount, outXpadIds, count));
    return gotCount;
}

int GetXpadPlayerNumber(const JoyXpadId& xpadId) NN_NOEXCEPT
{
    int value;
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetXpadPlayerNumber(&value, xpadId));
    return value;
}

void InitializeXpad(const JoyXpadId& xpadId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeXpad(xpadId));
}

void GetJoyXpadRightState(JoyXpadState* outValue, const JoyXpadId& xpadId
                          ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetJoyXpadRightState(outValue, xpadId));
}

void GetJoyXpadLeftState(JoyXpadState* outValue, const JoyXpadId& xpadId
                          ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetJoyXpadLeftState(outValue, xpadId));
}

int GetJoyXpadRightStates(JoyXpadState* outStates,
                          int count,
                          const JoyXpadId& xpadId) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetJoyXpadRightStates(&gotCount, outStates, count, xpadId));
    return gotCount;
}

int GetJoyXpadLeftStates(JoyXpadState* outStates,
                         int count,
                         const JoyXpadId& xpadId) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetJoyXpadLeftStates(&gotCount, outStates, count, xpadId));
    return gotCount;
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

void FinalizeXpad(const JoyXpadId& xpadId) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeXpad(xpadId));
}

}}} // namespace nn::hid::debug
