﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/system/hid_Irsensor.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

#include "detail/hid_NpadSystemImpl.h"

namespace nn { namespace hid { namespace system {

Result GetXcdHandleForNpadWithIrSensor(nn::xcd::DeviceHandle* pOutHandle, NpadIdType npadId) NN_NOEXCEPT
{
    auto result = detail::GetXcdHandleForNpadWithIrSensor(pOutHandle, npadId);

    if(result.IsFailure() == true &&
       ResultNoIrSensorDeviceFoundOnNpad::Includes(result) == false)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

void BindIrSensorEvent(NpadIdType npadId,
                       ::nn::os::SystemEventType* pEvent,
                       ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::BindIrSensorEvent(npadId, pEvent, clearMode));
}

IrSensorState GetIrSensorState(NpadIdType npadId) NN_NOEXCEPT
{
    IrSensorState state;

    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetIrSensorState(&state, npadId));

    return state;
}

Result ActivateIrSensor(NpadIdType npadId, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    auto result = detail::ActivateIrSensor(npadId, aruid);

    if (result.IsFailure() == true &&
        ResultNoIrSensorDeviceFoundOnNpad::Includes(result) == false &&
        ResultIrSensorActivationLimitOver::Includes(result) == false &&
        ResultIrSensorActivateFailureNpadBusy::Includes(result) == false)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

Result DeactivateIrSensor(NpadIdType npadId, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    auto result = detail::DeactivateIrSensor(npadId, aruid);

    if(result.IsFailure() == true &&
       ResultNoIrSensorDeviceFoundOnNpad::Includes(result) == false)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::hid::system

