﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/debug/hid_InputDetection.h>
#include <nn/hid/system/hid_InputDetection.h>

#include "detail/hid_InputDetectorImpl.h"

namespace nn { namespace hid { namespace system {

void InitializeInputDetector() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeInputDetector());
}

void GetInputSourceState(InputSourceState* pOutValue,
                         const InputSourceIdSet& id) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetInputSourceState(pOutValue, id));
}

void NotifyInputDetector(const InputSourceIdSet& id) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::NotifyInputDetector(id));
}

}}} // namespace nn::hid::system

namespace nn { namespace hid { namespace debug {

void FinalizeInputDetector() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeInputDetector());
}

}}} // namespace nn::hid::debug
