﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/debug/hid_HomeButton.h>
#include <nn/hid/system/hid_HomeButton.h>
#include <nn/os/os_SystemEventTypes.h>

#include "detail/hid_HomeButtonImpl.h"

namespace nn { namespace hid { namespace system {

void BindHomeButtonEvent(::nn::os::SystemEventType* pEvent,
                         ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::BindHomeButtonEvent(pEvent, clearMode));
}

void InitializeHomeButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::InitializeHomeButton());
}

int GetHomeButtonStates(HomeButtonState* outStates, int count) NN_NOEXCEPT
{
    auto gotCount = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::GetHomeButtonStates(&gotCount, outStates, count));
    return gotCount;
}

}}} // namespace nn::hid::system

namespace nn { namespace hid { namespace debug {

void FinalizeHomeButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::FinalizeHomeButton());
}

void SetHomeButtonAutoPilotState(const HomeButtonAutoPilotState& value
                                 ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetHomeButtonAutoPilotState(value));
}

void UnsetHomeButtonAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetHomeButtonAutoPilotState());
}

}}} // namespace nn::hid::debug
