﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>

#include <nn/hid/hid_ExternalBus.h>

#include "detail/hid_ExternalBusHandle.h"
#include "detail/hid_ExternalBusImpl.h"

namespace nn { namespace hid {

nn::Result CheckValidExternalBusHandle(ExternalBusHandle handle) NN_NOEXCEPT
{
    return detail::CheckValidExternalBusHandle(handle);
}

bool GetExternalBusHandle(ExternalBusHandle* pOutHandle, const nn::hid::NpadIdType &id, ExternalBusType busType) NN_NOEXCEPT
{
    return detail::GetExternalBusHandle(pOutHandle, id, busType);
}

nn::Result IsExternalBusDeviceConnected(bool* pOutIsConnected, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::IsExternalBusDeviceConnected(pOutIsConnected, handle);
}

nn::Result InitializeExternalBus(const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::InitializeExternalBus(handle);
}

nn::Result FinalizeExternalBus(const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::FinalizeExternalBus(handle);
}

nn::Result EnableExternalBusDevice(const ExternalBusHandle& handle, bool isEnabled, uint64_t version) NN_NOEXCEPT
{
    return detail::EnableExternalBusDevice(handle, isEnabled, version);
}

nn::Result GetExternalBusDeviceInfo(ExternalBusDeviceInfo* pOutInfo, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::GetExternalBusDeviceInfo(pOutInfo, handle);
}

nn::Result SendCommandAsyncToExternalBusDevice(const uint8_t* pInCommand, size_t inCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::SendCommandAsyncToExternalBusDevice(pInCommand, inCommandSize, handle);
}

nn::Result GetSendCommandAsynceResultFromExternalBusDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::GetSendCommandAsynceResultFromExternalBusDevice(pOutSize, pOutCommand, outCommandSize, handle);
}

nn::Result BindEventForExternalBusDeviceSendCommandAsycResult(nn::sf::Out<nn::sf::NativeHandle> receiveEventHandle, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::BindEventForExternalBusDeviceSendCommandAsycResult(receiveEventHandle, handle);
}

nn::Result EnablePollingReceiveModeForAttachmentDevice(const uint8_t* pInCommand, size_t inCommandSize, const ExternalBusHandle& handle, ExternalBusJoyPollingMode mode) NN_NOEXCEPT
{
    return detail::EnablePollingReceiveModeForAttachmentDevice(pInCommand, inCommandSize, handle, mode);
}

nn::Result DisablePollingReceiveModeForAttachmentDevice(const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::DisablePollingReceiveModeForAttachmentDevice(handle);
}

nn::Result GetPollingDataForAttachmentDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize, const ExternalBusHandle& handle) NN_NOEXCEPT
{
    return detail::GetPollingDataForAttachmentDevice(pOutSize, pOutCommand, outCommandSize, handle);
}

}} // namespace nn::hid

