﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_DebugPadMap.h>
#include <nn/settings/settings_DebugPad.h>

#include "detail/hid_DebugPadMapImpl.h"

namespace nn { namespace hid {

::nn::Result GetDebugPadGenericPadMap(
    ::nn::settings::DebugPadGenericPadMap* outValue) NN_NOEXCEPT
{
    return detail::GetDebugPadGenericPadMap(outValue);
}

::nn::Result SetDebugPadGenericPadMap(
    const ::nn::settings::DebugPadGenericPadMap& value) NN_NOEXCEPT
{
    return detail::SetDebugPadGenericPadMap(value);
}

::nn::Result ResetDebugPadGenericPadMap() NN_NOEXCEPT
{
    return detail::ResetDebugPadGenericPadMap();
}

::nn::Result GetDebugPadKeyboardMap(
    ::nn::settings::DebugPadKeyboardMap* outValue) NN_NOEXCEPT
{
    return detail::GetDebugPadKeyboardMap(outValue);
}

::nn::Result SetDebugPadKeyboardMap(
    const ::nn::settings::DebugPadKeyboardMap& value) NN_NOEXCEPT
{
    return detail::SetDebugPadKeyboardMap(value);
}

::nn::Result ResetDebugPadKeyboardMap() NN_NOEXCEPT
{
    return detail::ResetDebugPadKeyboardMap();
}

}} // namespace nn::hid
