﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   本体機能での利用を想定した、コントローラーサポートの UI 呼び出しに関する API の定義
 */

#include <nn/nn_SdkAssert.h>
#include <nn/hid/system/hid_ControllerSupport.h>

#include "detail/hid_ControllerSupportImpl.h"

//---------------------------------------------------------------------------
// C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace hid { namespace system {

//---------------------------------------------------------------------------
//
nn::Result ShowControllerSupportForSystem( const ControllerSupportArg& showControllerSupportArg, bool showConnectionStatus ) NN_NOEXCEPT
{
    ControllerSupportResultInfo dummy; // 呼び出し元には返さない
    return ShowControllerSupportForSystem( &dummy, showControllerSupportArg, showConnectionStatus );
}

//---------------------------------------------------------------------------
//
nn::Result ShowControllerSupportForSystem( ControllerSupportResultInfo* pOutValue, const ControllerSupportArg& showControllerSupportArg, bool showConnectionStatus ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( pOutValue );

    system::ControllerSupportArgPrivate privateArg;
    privateArg.SetDefault();
    privateArg.showConnectionStatus = showConnectionStatus;
    privateArg.isSystem = true;

    return detail::ShowControllerSupportCore( pOutValue, showControllerSupportArg, privateArg );
}

//---------------------------------------------------------------------------
//
nn::Result ShowControllerFirmwareUpdateForSystem( const ControllerFirmwareUpdateArg& showControllerFirmwareUpdateArg, ControllerSupportCaller caller ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_EQUAL( caller, ControllerSupportCaller_Application );

    system::ControllerSupportArgPrivate privateArg;
    privateArg.SetDefault();
    privateArg.mode = nn::hid::system::ControllerSupportMode_FirmwareUpdate;
    privateArg.caller = caller;
    privateArg.isSystem = true;

    return detail::ShowControllerFirmwareUpdateCore( showControllerFirmwareUpdateArg, privateArg );
}

}}} // namespace nn::hid::system

