﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/hid_SevenSixAxisSensorFusionApi.h>
#include <nn/hid/tmp/hid_ConsoleSixAxisSensor.h>

#include <nn/util/util_Matrix.h>
#include <nn/util/util_Quaternion.h>

#include "detail/hid_ConsoleSixAxisSensorHandle.h"
#include "detail/hid_ConsoleSixAxisSensorImpl.h"
#include "detail/hid_NpadImpl.h"
#include "detail/hid_SixAxisSensorImpl.h"

namespace nn { namespace hid {

void InitializeConsoleSixAxisSensor() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeConsoleSixAxisSensor());
}

void GetSixAxisSensorHandle(ConsoleSixAxisSensorHandle* pOutHandle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetConsoleSixAxisSensorHandle(pOutHandle));
}

void StartSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::StartSixAxisSensor(handle));
}

void StopSixAxisSensor(const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::StopSixAxisSensor(handle));
}

void InitializeSevenSixAxisSensor(void* workBuffer, size_t workBufferSize) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::InitializeSevenSixAxisSensor(workBuffer, workBufferSize));
}

void FinalizeSevenSixAxisSensor() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeSevenSixAxisSensor());
}

::nn::Result StartSevenSixAxisSensor() NN_NOEXCEPT
{
    return detail::StartSevenSixAxisSensor();
}

void StopSevenSixAxisSensor() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::StopSevenSixAxisSensor());
}

int GetSevenSixAxisSensorStates(SevenSixAxisSensorState* pOutStates,
    int count) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetSevenSixAxisSensorStates(&gotCount, pOutStates, count));
    return gotCount;
}

bool IsSevenSixAxisSensorAtRest() NN_NOEXCEPT
{
    bool isAtRest;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::IsSevenSixAxisSensorAtRest(&isAtRest));
    return isAtRest;
}

// For Debug purpose only
float GetSensorFusionErrorForDebug() NN_NOEXCEPT
{
    float sensorFusionError = 0.f;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetSensorFusionError(&sensorFusionError));
    return sensorFusionError;
}

// For Debug purpose only
::nn::util::Float3 GetGyroBiasForDebug() NN_NOEXCEPT
{
    ::nn::util::Float3 gyroBias;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetGyroBias(&gyroBias));
    return gyroBias;
}

::nn::Result SetSevenSixAxisSensorFusionStrength(float strength) NN_NOEXCEPT
{
    return detail::SetSevenSixAxisSensorFusionStrength(strength);
}

::nn::Result GetSevenSixAxisSensorFusionStrength(float* pOutStrength) NN_NOEXCEPT
{
    return detail::GetSevenSixAxisSensorFusionStrength(pOutStrength);
}

}} // namespace nn::hid

namespace nn { namespace hid { namespace debug {

int GetConsoleSixAxisSensorCountStates(ConsoleSixAxisSensorCountState* pOutStates,
                                       int count) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetConsoleSixAxisSensorCountStates(&gotCount,
                                                   pOutStates,
                                                   count)
    );
    return gotCount;
}

int64_t GetConsoleSixAxisSensorSamplingFrequency() NN_NOEXCEPT
{
    int64_t samplingFrequency = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetConsoleSixAxisSensorSamplingFrequency(&samplingFrequency));
    return samplingFrequency;
}

void FinalizeConsoleSixAxisSensor() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeConsoleSixAxisSensor());
}

void FinalizeSevenSixAxisSensor() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::FinalizeConsoleSixAxisSensor());
}

}}} // namespace nn::hid::debug

namespace nn { namespace hid { namespace tmp {

int GetConsoleSixAxisSensorCountStates(SixAxisSensorCountState* outStates,
                                       int count,
                                       const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    int gotCount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetConsoleSixAxisSensorCountStates(&gotCount, outStates, count, handle));
    return gotCount;
}

void GetConsoleSixAxisSensorCalibrationValues(ConsoleSixAxisSensorCalibrationValues* pOutCalibrationValues,
                                              const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetConsoleSixAxisSensorCalibrationValues(pOutCalibrationValues, handle));
}

}}} // namespace nn::hid::tmp
