﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/hid/debug/hid_CaptureButton.h>
#include <nn/hid/system/hid_CaptureButton.h>
#include <nn/os/os_SystemEventTypes.h>

#include "detail/hid_CaptureButtonImpl.h"

namespace nn { namespace hid { namespace system {

void BindCaptureButtonEvent(::nn::os::SystemEventType* pEvent,
                          ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::BindCaptureButtonEvent(pEvent, clearMode));
}

void InitializeCaptureButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::InitializeCaptureButton());
}

int GetCaptureButtonStates(CaptureButtonState* outStates, int count) NN_NOEXCEPT
{
    auto gotCount = int();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::GetCaptureButtonStates(&gotCount, outStates, count));
    return gotCount;
}

}}} // namespace nn::hid::system

namespace nn { namespace hid { namespace debug {

void FinalizeCaptureButton() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::FinalizeCaptureButton());
}

void SetCaptureButtonAutoPilotState(const CaptureButtonAutoPilotState& value
                                    ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::SetCaptureButtonAutoPilotState(value));
}

void UnsetCaptureButtonAutoPilotState() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::hid::detail::UnsetCaptureButtonAutoPilotState());
}

}}} // namespace nn::hid::debug
