﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Xpad.h>
#include <nn/settings/settings_Xpad.h>

#include "hid_ActivationCount.h"
#include "hid_IXpadDriver.h"
#include "hid_WindowsGenericPad-os.win.h"
#include "hid_WindowsKeyboard-os.win.h"
#include "hid_XpadMappingManager.h"

namespace nn { namespace hid { namespace detail {

class XpadDriver final : public IXpadDriver
{
    NN_DISALLOW_COPY(XpadDriver);
    NN_DISALLOW_MOVE(XpadDriver);

private:
    //!< アクティブ化した回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< Windows の汎用コントローラ
    WindowsGenericPad m_WindowsGenericPad;

    //!< Windows のキーボード
    WindowsKeyboard m_WindowsKeyboard;

    //!< 汎用ゲームパッドの割り当て
    ::nn::settings::BasicXpadGenericPadMap m_GenericPadMap;

    //!< キーボードの割り当て
    ::nn::settings::BasicXpadKeyboardMap m_KeyboardMap;

    //!< HidShell のポート番号
    int m_HidShellPort;

    //!< マッピングマネージャを指すポインタ
    XpadMappingManager* m_pMappingManager;

public:
    XpadDriver() NN_NOEXCEPT;

    virtual ~XpadDriver() NN_NOEXCEPT NN_OVERRIDE;

    void SetHidShellPort(int port) NN_NOEXCEPT;

    void SetMappingManager(XpadMappingManager* pMappingManager) NN_NOEXCEPT;

    virtual bool IsActivated() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(BasicXpadState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
