﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Xpad.h>

#include "hid_ActivationCount.h"
#include "hid_IXpadDriver.h"

namespace nn { namespace hid { namespace detail {

class XpadDriver final : public IXpadDriver
{
    NN_DISALLOW_COPY(XpadDriver);
    NN_DISALLOW_MOVE(XpadDriver);

private:
    //!< アクティブ化した回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

public:
    XpadDriver() NN_NOEXCEPT;

    virtual ~XpadDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool IsActivated() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(BasicXpadState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

};

}}} // namespace nn::hid::detail
