﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/hid/hid_VibrationDeviceApi.h>
#include <nn/hid/hid_VibrationValueTypes.h>
#include <nn/xcd/xcd_Vibration.h>

#include "hid_IVibratorDriver.h"

namespace nn { namespace hid { namespace detail {

struct VibratorXcdConfig final
{
    ::nn::xcd::DeviceHandle handle;
    ::nn::xcd::VibratorPosition position;
};

class VibratorXcdDriver final : public IVibratorDriver
{
private:
    int m_ReferenceCount;
    VibratorXcdConfig m_Config;
    bool m_IsActivated;

public:
    VibratorXcdDriver() NN_NOEXCEPT :
        m_ReferenceCount(0), m_IsActivated(false)
    {};

    virtual ~VibratorXcdDriver() NN_NOEXCEPT NN_OVERRIDE {};
    virtual Result IncreaseReferenceCount() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result DecreaseReferenceCount() NN_NOEXCEPT NN_OVERRIDE;
    virtual void ForceStopVibration() NN_NOEXCEPT NN_OVERRIDE;
    Result ActivateVibrator(VibratorXcdConfig vibratorXcdConfig) NN_NOEXCEPT;
    Result DeactivateVibrator() NN_NOEXCEPT;
    Result SetEnabled(bool isEnabled) NN_NOEXCEPT;
    Result SendVibrationValue(const VibrationValue& value) NN_NOEXCEPT;
    Result GetActualVibrationValue(VibrationValue* pOutValue) NN_NOEXCEPT;
    Result StartVibrationOnConnect() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
