﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/hid/system/hid_CommonTypes.h>
#include <nn/hid/system/hid_UniquePad.h>

namespace nn { namespace hid { namespace detail {

inline system::UniquePadType ConvertToUniquePadType(const system::DeviceTypeSet& deviceType) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(deviceType.CountPopulation(), 1);
    if (deviceType == system::DeviceType::FullKeyController::Mask)
    {
        return system::UniquePadType_FullKeyController;
    }
    if (deviceType == system::DeviceType::JoyConLeft::Mask ||
        deviceType == system::DeviceType::HandheldJoyLeft::Mask)
    {
        return system::UniquePadType_LeftController;
    }
    if (deviceType == system::DeviceType::JoyConRight::Mask ||
        deviceType == system::DeviceType::HandheldJoyRight::Mask)
    {
        return system::UniquePadType_RightController;
    }
    return system::UniquePadType_Unknown;
}

inline system::UniquePadInterface ConvertToUniquePadInterface(const system::InterfaceType& type)
{
    switch(type)
    {
    case system::InterfaceType_Bluetooth:
        return ::nn::hid::system::UniquePadInterface_Bluetooth;
    case system::InterfaceType_Rail:
        return ::nn::hid::system::UniquePadInterface_Rail;
    case system::InterfaceType_Usb:
        return ::nn::hid::system::UniquePadInterface_Usb;
    default:
        NN_ABORT("Unexpected InterfaceType (%x) returned", type);
        NN_UNEXPECTED_DEFAULT;
    }
}

}}} // namespace nn::hid::detail
