﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/system/hid_SixAxisSensorCalibration.h>
#include <nn/hid/system/hid_UniquePad.h>

namespace nn { namespace hid { namespace detail {

inline system::UniqueSixAxisSensorHandle GetUniqueSixAxisSensorHandleFromUniquePadId(system::UniquePadId id) NN_NOEXCEPT
{
    system::UniqueSixAxisSensorHandle handle;
    handle._storage = static_cast<int32_t>(id._storage);
    return handle;
}

inline ::nn::hid::system::UniquePadId GetUniquePadIdFromUniqueSixAxisSensorHandle(system::UniqueSixAxisSensorHandle handle) NN_NOEXCEPT
{
    system::UniquePadId id;
    id._storage = static_cast<int64_t>(handle._storage);
    return id;
}

// int から SixAxisSensorUserCalibrationStage に変換
template<typename T>
inline system::SixAxisSensorUserCalibrationStage GetSixAxisSensorUserCalibrationStageFromInt(T value)
{
    switch (value)
    {
    case system::SixAxisSensorUserCalibrationStage_Measuring:
        return system::SixAxisSensorUserCalibrationStage_Measuring;
    case system::SixAxisSensorUserCalibrationStage_Update:
        return system::SixAxisSensorUserCalibrationStage_Update;
    case system::SixAxisSensorUserCalibrationStage_Completed:
        return system::SixAxisSensorUserCalibrationStage_Completed;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}


}}} // namespace nn::hid::detail
