﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "hid_IAbstractedPad.h"

namespace nn { namespace hid { namespace detail {

//!< UniquePad に対して割り当てられた AbstractedPad を管理するクラスです。
class UniquePadAbstractedPadHolder final
{
    NN_DISALLOW_COPY(UniquePadAbstractedPadHolder);
    NN_DISALLOW_MOVE(UniquePadAbstractedPadHolder);

private:
    IAbstractedPad* m_pPad;

public:
    UniquePadAbstractedPadHolder() NN_NOEXCEPT;

    ~UniquePadAbstractedPadHolder() NN_NOEXCEPT;

    //!< 接続されたデバイスをもとに、ドライバを有効にします。
    void AttachAbstractedPad(IAbstractedPad* pPad) NN_NOEXCEPT;

    //!< 切断済みであればデバイスを切断します。
    bool CheckForDeviceDetach() NN_NOEXCEPT;

    //!< 接続されているか否かを返します。
    bool IsConnected() const NN_NOEXCEPT;

    //!< 接続済みの AbstractedPad と一致するかどうか
    bool IsConnectedAbstractedPad(const AbstractedPadId& id) const NN_NOEXCEPT;

    //!< AbstractedPad を返します。
    bool GetIAbstractedPad(IAbstractedPad** ppOutValue) const NN_NOEXCEPT;

    //!< Xcd デバイスの場合は デバイスハンドルを返します。
    bool GetXcdDeviceHandle(nn::xcd::DeviceHandle* pOutValue) const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
