﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nn/hid/debug/hid_TouchScreen.h>

#include "hid_ITouchScreenDriver.h"

namespace nn { namespace hid { namespace detail {

::nn::Result InitializeTouchScreen() NN_NOEXCEPT;

::nn::Result FinalizeTouchScreen() NN_NOEXCEPT;

template<size_t N>
::nn::Result GetTouchScreenState(TouchScreenState<N>* pOutValue) NN_NOEXCEPT;

template<size_t N>
::nn::Result GetTouchScreenStates(int* pOutCount,
                                  TouchScreenState<N>* outStates,
                                  int count) NN_NOEXCEPT;

template<size_t N>
::nn::Result SetTouchScreenAutoPilotState(
    const ::nn::hid::debug::TouchScreenAutoPilotState<N>& value) NN_NOEXCEPT;

::nn::Result UnsetTouchScreenAutoPilotState() NN_NOEXCEPT;

}}} // namespace nn::hid::detail
