﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_TouchScreen.h>

#include "hid_ActivationCount.h"
#include "hid_ITouchScreenDriver.h"

namespace nn { namespace hid { namespace detail {

class TouchScreenDriver final : public ITouchScreenDriver
{
    NN_DISALLOW_COPY(TouchScreenDriver);
    NN_DISALLOW_MOVE(TouchScreenDriver);

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

public:
    TouchScreenDriver() NN_NOEXCEPT;

    virtual ~TouchScreenDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Wake() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Sleep() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(TouchScreenState<TouchStateCountMax>* pOutValue
                          ) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
