﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/xcd/xcd_Device.h>

#include "hid_IAbstractedPad.h"
#include "hid_ActivationCount.h"
#include "hid_SixAxisSensorHandle.h"
#include "hid_SixAxisSensorProcessor.h"

namespace nn { namespace hid { namespace detail {

struct SixAxisSensorXcdConfig
{
    IAbstractedPad* pPad;
};

class SixAxisSensorXcdDriver final
{
    NN_DISALLOW_COPY(SixAxisSensorXcdDriver);
    NN_DISALLOW_MOVE(SixAxisSensorXcdDriver);

private:
    ActivationCount         m_ActivationCount;
    SixAxisSensorProcessor  m_SixAxisSensorProcessor;
    SixAxisSensorXcdConfig  m_Config;
    SixAxisSensorSetting    m_DummySetting;

public:
    SixAxisSensorXcdDriver() NN_NOEXCEPT
    {
        m_DummySetting.accelerometerSetting.Reset(true);
        m_DummySetting.gyroscopeSetting.Reset(true);
        m_DummySetting.sixAxisSensorProcessorSetting.Reset(true);

        SetSixAxisSensorSetting(&m_DummySetting);
    };

    ~SixAxisSensorXcdDriver() NN_NOEXCEPT {};

    // Xpad の互換性担保のためにだけ残す
    SixAxisSensorProcessor* GetSixAxisSensorProcessor() NN_NOEXCEPT
    {
        return &m_SixAxisSensorProcessor;
    }

    const SixAxisSensorProcessor& GetSixAxisSensorProcessorInstance() const NN_NOEXCEPT
    {
        return m_SixAxisSensorProcessor;
    }

    Result ActivateSixAxisSensor(SixAxisSensorXcdConfig config) NN_NOEXCEPT;

    Result DeactivateSixAxisSensor() NN_NOEXCEPT;

    void Sample() NN_NOEXCEPT;

    int GetSixAxisSensorStates(SixAxisSensorState* outStates, int count) const NN_NOEXCEPT;

    void SetSixAxisSensorSetting(const SixAxisSensorSetting* const pSetting) NN_NOEXCEPT;

    bool IsSixAxisSensorAtRest() const NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
