﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/system/hid_RegisteredDevice.h>

namespace nn { namespace hid { namespace detail {

::nn::Result GetRegisteredDevices(int* pOutCount,
                                  system::RegisteredDevice* outValues,
                                  int count) NN_NOEXCEPT;

::nn::Result GetConnectableRegisteredDevices(int* pOutCount,
                                             system::RegisteredDevice* outValues,
                                             int count) NN_NOEXCEPT;

::nn::Result BindConnectionTriggerTimeoutEvent(nn::os::SystemEventType* pSystemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT;

::nn::Result SendConnectionTrigger(nn::bluetooth::Address address) NN_NOEXCEPT;

::nn::Result BindDeviceRegisteredEventForControllerSupport(nn::os::SystemEventType* pSystemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT;

int GetAllowedBluetoothLinksCount() NN_NOEXCEPT;

::nn::Result AddRegisteredDevice(const system::RegisteredDevice& device) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
