﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/hid/system/hid_PlayReport.h>

namespace nn { namespace hid { namespace detail {

::nn::Result BindPlayReportControllerUsageUpdateEvent(::nn::os::SystemEventType* pEvent,
                                              ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

::nn::Result GetPlayReportControllerUsages(int* pOutCount,
                                           system::PlayReportControllerUsage* outValues,
                                           int count) NN_NOEXCEPT;

::nn::Result BindPlayReportRegisteredDeviceUpdateEvent(::nn::os::SystemEventType* pEvent,
                                               ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
