﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidSystemServer.sfdl.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ISharedObject.h>

#include "hid_PlayReportImpl.h"
#include "hid_HidSystemServer.h"

namespace nn { namespace hid { namespace detail {

::nn::Result BindPlayReportControllerUsageUpdateEvent(::nn::os::SystemEventType* pEvent,
                                              ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    auto handle = ::nn::sf::NativeHandle();
    NN_RESULT_DO(pProxy->AcquirePlayReportControllerUsageUpdateEvent(&handle));

    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);

    // ハンドルの管理権を放棄
    handle.Detach();
    NN_RESULT_SUCCESS;
}

::nn::Result GetPlayReportControllerUsages(int* pOutCount,
                                           system::PlayReportControllerUsage* outValues,
                                           int count) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    auto gotCount = int64_t();
    NN_RESULT_DO(
        pProxy->GetPlayReportControllerUsages(::nn::sf::Out<int64_t>(&gotCount),
                                              ::nn::sf::OutArray<system::PlayReportControllerUsage>(
                                                  outValues, static_cast<size_t>(count))));
    *pOutCount = static_cast<int>(gotCount);
    NN_RESULT_SUCCESS;
}

::nn::Result BindPlayReportRegisteredDeviceUpdateEvent(::nn::os::SystemEventType* pEvent,
                                               ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IHidSystemServer> pProxy;
    NN_RESULT_DO(CreateHidSystemServerProxy(&pProxy));
    auto handle = ::nn::sf::NativeHandle();

    NN_RESULT_DO(pProxy->AcquirePlayReportRegisteredDeviceUpdateEvent(&handle));

    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);

    // ハンドルの管理権を放棄
    handle.Detach();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
