﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/hid/hid_NpadCommonTypes.h>
#include <nn/hid/hid_PalmaTypes.h>

namespace nn { namespace hid { namespace detail {

Result GetPalmaConnectionHandle(PalmaConnectionHandle* pOutHandle, const NpadIdType& id) NN_NOEXCEPT;
Result InitializePalma(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result BindPalmaOperationCompleteEvent(const PalmaConnectionHandle& handle, nn::os::SystemEventType* pEvent, ::nn::os::EventClearMode clearMode) NN_NOEXCEPT;
Result GetPalmaOperationInfo(PalmaOperationInfo* pOutValue, const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result PlayPalmaActivity(const PalmaConnectionHandle& handle, const PalmaActivityIndex& index) NN_NOEXCEPT;
Result SetPalmaFrModeType(const PalmaConnectionHandle& handle, const PalmaFrModeType& type) NN_NOEXCEPT;
Result ReadPalmaStep(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result EnablePalmaStep(const PalmaConnectionHandle& handle, bool isEnabled) NN_NOEXCEPT;
Result ResetPalmaStep(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result ReadPalmaApplicationSection(const PalmaConnectionHandle& handle, int address, size_t size) NN_NOEXCEPT;
Result WritePalmaApplicationSection(const PalmaConnectionHandle& handle, int address, size_t size, const PalmaApplicationSectionAccessBuffer& buffer) NN_NOEXCEPT;
Result ReadPalmaUniqueCode(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result SetPalmaUniqueCodeInvalid(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result WritePalmaActivityEntry(const PalmaConnectionHandle& handle, const PalmaActivityIndex& index, const PalmaActivityEntry* pEntry) NN_NOEXCEPT;
Result WritePalmaRgbLedPatternEntry(const PalmaConnectionHandle& handle, const PalmaRgbLedPatternIndex& index, const void* pRgbLedPatternBuffer, size_t size) NN_NOEXCEPT;
Result WritePalmaWaveEntry(const PalmaConnectionHandle& handle, const PalmaWaveSet& waveSet, const PalmaWaveIndex& index, const void* pWaveBuffer, size_t bufferSize, size_t waveDataSize) NN_NOEXCEPT;
Result SetPalmaDataBaseIdentificationVersion(const PalmaConnectionHandle& handle, int version) NN_NOEXCEPT;
Result GetPalmaDataBaseIdentificationVersion(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result SuspendPalmaFeature(const PalmaConnectionHandle& handle, const PalmaFeatureSet& suspendFeatureSet) NN_NOEXCEPT;
Result ReadPalmaPlayLog(const PalmaConnectionHandle& handle, const PalmaPlayLogFieldIndex& index) NN_NOEXCEPT;
Result ResetPalmaPlayLog(const PalmaConnectionHandle& handle, const PalmaPlayLogFieldIndex& index) NN_NOEXCEPT;
Result EnablePairedPalmaConnection() NN_NOEXCEPT;
Result DisablePairedPalmaConnection() NN_NOEXCEPT;
Result EnableAnyPalmaConnection() NN_NOEXCEPT;
Result DisableAnyPalmaConnection() NN_NOEXCEPT;
Result PairPalma(const PalmaConnectionHandle& handle) NN_NOEXCEPT;
Result SetPalmaBoostMode(bool enabled) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
