﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace hid { namespace detail {

/**
 * @brief       Joy-Con レールに接続できる拡張デバイスの状態です。
 */
enum NpadJoyConRailAttachmentState
{
    NpadJoyConRailAttachmentState_NoDevice,       //!< レール接続デバイスに対応したコントローラーが接続されていません
    NpadJoyConRailAttachmentState_Deactivated,    //!< レール拡張デバイスが 1台以上接続されており、非アクティベート状態にあります。
    NpadJoyConRailAttachmentState_Activated,      //!< レール拡張デバイスが 1台以上接続されており、アクティベート状態にあります。競合する他の機能を有効にできなくなります
};

const int JoyConRailAttachmentCountMaxPerNpad = 2; //!< レール接続拡張コントローラーが Npad あたりに接続できる最大数です。

/**
 * @brief       レールを表す列挙帯です
 */
enum NpadJoyConRailIndex
{
    NpadJoyConRailIndex_Left = 0,       //!< 左 Joy-Con レール
    NpadJoyConRailIndex_Right,          //!< 右 Joy-Con レール
};

}}} // namespace nn::hid::detail
