﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Mouse.h>

#include "hid_ActivationCount.h"
#include "hid_IMouseDriver.h"
#include "hid_Point.h"

namespace nn { namespace hid { namespace detail {

class MouseDriver final : public IMouseDriver
{
    NN_DISALLOW_COPY(MouseDriver);
    NN_DISALLOW_MOVE(MouseDriver);

private:
    //!< このインスタンスからドライバがアクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< スクリーンと見做せるウィンドウが存在するか否か
    bool m_HasWindow;

    //!< カーソルを補足しているか否か
    bool m_HasCursor;

    //!< サンプリング番号
    int64_t m_SamplingNumber;

    //!< カーソルの相対座標
    Point m_RelativePosition;

    //!< カーソルの絶対座標
    Point m_AbsolutePosition;

public:
    MouseDriver() NN_NOEXCEPT;

    virtual ~MouseDriver() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Activate() NN_NOEXCEPT NN_OVERRIDE;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT NN_OVERRIDE;

    virtual void GetState(MouseState* pOutValue) NN_NOEXCEPT NN_OVERRIDE;
};

}}} // namespace nn::hid::detail
