﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_Keyboard.h>
#include <nn/hid/debug/hid_Keyboard.h>
#include <nn/hid/system/hid_Keyboard.h>

namespace nn { namespace hid { namespace detail {

::nn::Result InitializeKeyboard() NN_NOEXCEPT;

::nn::Result FinalizeKeyboard() NN_NOEXCEPT;

::nn::Result GetKeyboardState(KeyboardState* pOutValue) NN_NOEXCEPT;

::nn::Result GetKeyboardStates(
    int* pOutCount, KeyboardState outStates[], int count) NN_NOEXCEPT;

::nn::Result SetKeyboardAutoPilotState(
    const ::nn::hid::debug::KeyboardAutoPilotState& value) NN_NOEXCEPT;

::nn::Result UnsetKeyboardAutoPilotState() NN_NOEXCEPT;

::nn::Result SendKeyboardLockKeyEvent(
    ::nn::hid::system::KeyboardLockKeyEventSet value) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
