﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_JoyXpad.h>

namespace nn { namespace hid { namespace detail {

::nn::Result GetXpadIds(int* outGotCount, JoyXpadId* outXpadIds, int count
                        ) NN_NOEXCEPT;

::nn::Result GetXpadPlayerNumber(int* outValue, const JoyXpadId& xpadId
                                 ) NN_NOEXCEPT;

::nn::Result InitializeXpad(const JoyXpadId& xpadId) NN_NOEXCEPT;

::nn::Result FinalizeXpad(const JoyXpadId& xpadId) NN_NOEXCEPT;

::nn::Result GetJoyXpadRightState(JoyXpadState* outValue, const JoyXpadId& xpadId
                                  ) NN_NOEXCEPT;

::nn::Result GetJoyXpadLeftState(JoyXpadState* outValue, const JoyXpadId& xpadId
                                 ) NN_NOEXCEPT;

::nn::Result GetJoyXpadRightStates(int* outGotCount,
                                  JoyXpadState* outStates,
                                  int count,
                                  const JoyXpadId& xpadId) NN_NOEXCEPT;

::nn::Result GetJoyXpadLeftStates(int* outGotCount,
                                  JoyXpadState* outStates,
                                  int count,
                                  const JoyXpadId& xpadId) NN_NOEXCEPT;

::nn::Result AssertValidJoyXpadId(const JoyXpadId& xpadId) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
