﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/os/os_Tick.h>
#include <nn/hid/hid_SevenSixAxisSensor.h>
#include <nn/hid/system/hid_SixAxisSensorAccurateCalibration.h>

#include "hid_ConsoleSixAxisSensorAppletSetting.h"
#include "hid_ConsoleSixAxisSensorCalibrationTypes.h"
#include "hid_ConsoleSixAxisSensorLifo.h"

namespace nn { namespace hid { namespace detail {

class ISixAxisSensorFilter
{
public:
    virtual ~ISixAxisSensorFilter() NN_NOEXCEPT { /* 何もしない */ }

    virtual void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& id) NN_NOEXCEPT = 0;

    virtual ::nn::applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT = 0;

    virtual void Reset() NN_NOEXCEPT = 0;

    virtual void ResetState() NN_NOEXCEPT = 0;

    virtual void SetDirection(const nn::hid::DirectionState& direction) NN_NOEXCEPT = 0;
    virtual void SetAngle(const nn::util::Float3& angle) NN_NOEXCEPT = 0;
    virtual void SetPosition(const nn::util::Float3& position) NN_NOEXCEPT = 0;

    virtual bool GetState(SevenSixAxisSensorState* pOutValue,
                          nn::os::Tick* lastTime = nullptr) NN_NOEXCEPT = 0;

    virtual int GetStates(SevenSixAxisSensorState* pOutStates,
                          int count,
                          nn::os::Tick* lastTime = nullptr ) NN_NOEXCEPT = 0;

    virtual bool GetIsStill() NN_NOEXCEPT = 0;

    virtual float GetVerticalizationError() NN_NOEXCEPT = 0;

    virtual ::nn::util::Float3 GetGyroBias() NN_NOEXCEPT = 0;

    virtual void Update(const nn::util::Float3& acceleration,
                        const nn::util::Float3& angularVelocity,
                        const nn::os::Tick& time) NN_NOEXCEPT = 0;

    virtual void SetStateBuffer(const ::nn::applet::AppletResourceUserId& id, void* buffer, size_t size) NN_NOEXCEPT = 0;

    virtual void SetWorkBuffer(const ::nn::applet::AppletResourceUserId& id, void* buffer, size_t size) NN_NOEXCEPT = 0;

    virtual void ClearStateBuffer() NN_NOEXCEPT = 0;

    virtual void ClearWorkBuffer() NN_NOEXCEPT = 0;

    virtual void StartCalibration() NN_NOEXCEPT = 0;

    virtual void StopCalibration() NN_NOEXCEPT = 0;

    virtual void GetAccurateUserCalibrationState(
        ::nn::hid::system::SixAxisSensorAccurateUserCalibrationState* pOutValue) NN_NOEXCEPT = 0;

    virtual void GetCalibrationParameters(
        ConsoleSixAxisSensorCalibrationParameters* pOutParameters) const NN_NOEXCEPT = 0;

    virtual void SetCalibrationParameters(
        const ConsoleSixAxisSensorCalibrationParameters& parameters) NN_NOEXCEPT = 0;

    virtual bool IsWorkBufferAllocated() const NN_NOEXCEPT = 0;

    virtual void SetFilterSetting(const FilterSetting& setting) NN_NOEXCEPT = 0;
};

}}} // namespace nn::hid::detail
