﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/hid/hid_Mouse.h>

namespace nn { namespace hid { namespace detail {

class IMouseDriver
{
public:
    virtual ~IMouseDriver() NN_NOEXCEPT { /* 何もしない */ }

    virtual ::nn::Result Activate() NN_NOEXCEPT = 0;

    virtual ::nn::Result Deactivate() NN_NOEXCEPT = 0;

    virtual void GetState(MouseState* outValue) NN_NOEXCEPT = 0;
};

}}} // namespace nn::hid::detail
