﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_ExternalBus.h>

namespace nn { namespace hid { namespace detail {

class IExternalBusDriver
{
public:
    virtual ~IExternalBusDriver() NN_NOEXCEPT { /* 何もしない */ }

    virtual nn::Result Initialize() NN_NOEXCEPT = 0;
    virtual void Finalize() NN_NOEXCEPT = 0;

    virtual bool IsExternalConnecterDeviceConnected() NN_NOEXCEPT = 0;
    virtual nn::Result EnableExternalConnecterDevice(bool isEnabled, uint64_t version) NN_NOEXCEPT = 0;
    virtual nn::Result GetExternalConnecterDeviceInfo(ExternalBusDeviceInfo* pOutInfo) NN_NOEXCEPT = 0;
    virtual nn::Result SendCommandAsyncToExternalBusDevice(const uint8_t* pInCommand, size_t inCommandSize) NN_NOEXCEPT = 0;
    virtual nn::Result GetSendCommandAsynceResultFromExternalBusDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize) NN_NOEXCEPT = 0;
    virtual nn::Result SetEventForExternalBusDeviceSendCommandAsycResult(nn::os::SystemEventType* pReceiveEventHandle) NN_NOEXCEPT = 0;
    virtual nn::os::SystemEvent* GetInternalReceiveEventPointer() NN_NOEXCEPT = 0;
    virtual nn::os::Mutex* GetInternalEnableMutexPointer() NN_NOEXCEPT = 0;
    virtual nn::Result EnablePollingReceiveModeForAttachmentDevice(const uint8_t* pInCommand, size_t inCommandSize, ExternalBusJoyPollingMode mode) NN_NOEXCEPT = 0;
    virtual nn::Result DisablePollingReceiveModeForAttachmentDevice() NN_NOEXCEPT = 0;
    virtual nn::Result GetPollingDataForAttachmentDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize) NN_NOEXCEPT = 0;
};

}}} // namespace nn::hid::detail
